#include "osabstraction.h"

#ifdef USE_DIRECT_OS

bool fileClose(FileHandle fh)
{
   return (fclose(fh) == 0) ? TRUE : FALSE;
}

FileHandle fileOpenReadOnly(const char* name)
{
   return fopen(name, "rb");
}

FileHandle fileOpenWriteOnly(const char* name)
{
   return fopen(name, "wb");
}

bool removeFile(const char* name)
{
   return (remove(name) == 0) ? TRUE : FALSE;
}

size_t writeFile(const void *buffer, size_t size, size_t count, FileHandle stream)
{
   return fwrite(buffer, size, count, stream);
}

void* copyMemory(void *dest, const void *src, size_t count)
{
   return memcpy(dest, src, count);
}

void* setMemory(void *dest, int c, size_t count)
{
   return memset(dest, c, count);
}

size_t readFile(void *buffer, size_t size, size_t count, FileHandle stream)
{
   return fread(buffer, size, count, stream);
}

size_t getFileSize(FileHandle stream)
{
   fseek(stream, 0, SEEK_END);
   fpos_t srcLength;
   fgetpos(stream, &srcLength);
   fseek(stream, 0, SEEK_SET);
#if defined(WIN32) || defined(__APPLE__) || defined(ANDROID) || defined(__CYGWIN__)
   tS32 s32Size = (tS32) srcLength;
#else
   tS32 s32Size = (tS32) srcLength.__pos;
#endif

   return s32Size;
}

#else

bool fileClose(FileHandle fh)
{
   return (OSAL_s32IOClose(fh) == OSAL_OK) ? TRUE : FALSE;
}

FileHandle fileOpenReadOnly(const char* name)
{
   return OSAL_IOOpen (name, OSAL_EN_READONLY);
}

FileHandle fileOpenWriteOnly(const char* name)
{
   return OSAL_IOCreate (name, OSAL_EN_WRITEONLY);
}

bool removeFile(const char* name)
{
   return (OSAL_s32IORemove(name) == OSAL_OK) ? TRUE : FALSE;
}

size_t writeFile(const void *buffer, size_t /*size*/, size_t count, FileHandle stream)
{
   return OSAL_s32IOWrite(stream, (tPCS8)buffer, count);
}

void* copyMemory(void *dest, const void *src, size_t count)
{
   return OSAL_pvMemoryCopy(dest, src, count);
}

void* setMemory(void *dest, int c, size_t count)
{
   return OSAL_pvMemorySet( dest, c, count);
}

size_t readFile(void *buffer, size_t /*size*/, size_t count, FileHandle stream)
{
   return OSAL_s32IORead(stream, (tPS8)buffer, count);

}

size_t getFileSize(FileHandle stream)
{
   tS32 s32Size = OSALUTIL_s32FGetSize(stream);
   return s32Size;
}

#endif
